*** rt-arima-15y.do
*** v1.2.1
***
*** Creates ARIMA forecasts from real-time data. Outputs ur_NNN, where NNN is the date
***   of the first forecast for the UR (i.e., the unemployment rate is known through month
***   NNN-1). NNN is the Stata date code for months, where 192 = 1976m1.
***
clear all
set more off
set type double
set matsize 4000

global path = "$HOME/research/ssur"

cap log close
log using rt-arima-15y.log, text replace

local T = 15

use $path/data/rtdata/rt-E.dta, clear
merge 1:1 mdate using $path/data/rtdata/rt-U.dta, nogen
gen obs = _n

*** initialize ARIMA with values by decade
mat def b0_131=[4.9553427,   1.8449563,   -.8565582,  -.71569932,   .20649086]
mat colnames b0_131= "ur:_cons" "ARMA: L.ar" "ARMA: L2.ar" "ARMA: L.ma" "sigma:_cons"
mat def b0_251=[5.6382399,   1.8587382,  -.86485433,  -.66606447,   .18146966]
mat colnames b0_251 = "ur:_cons" "ARMA: L.ar" "ARMA: L2.ar" "ARMA: L.ma" "sigma:_cons"
mat def b0_371=[7.1516761,   1.9335857,  -.93847012,  -.82584619,   .17592166]
mat colnames b0_371 = "ur:_cons" "ARMA: L.ar" "ARMA: L2.ar" "ARMA: L.ma" "sigma:_cons"
mat def b0_491=[5.7573278,   1.9683233,  -.97025373,   -.9213353,   .12958244]
mat colnames b0_491 = "ur:_cons" "ARMA: L.ar" "ARMA: L2.ar" "ARMA: L.ma" "sigma:_cons"
mat def b0_611=[5.819647,   1.9619491,  -.96509127,    -.814463,    .1384599]
mat colnames b0_611 = "ur:_cons" "ARMA: L.ar" "ARMA: L2.ar" "ARMA: L.ma" "sigma:_cons"

cap confirm file rt-arima-15y.dta
if _rc==0 shell mv rt-arima-15y.dta rt-arima-15y.dta.bak

unab rellist: E_*
local rdatelist: subinstr local rellist "E_" "", all
local i = 1
preserve
foreach rdate of local rdatelist {
  * vintages of U_s begin in 1964m2
  if `rdate'>=tm(1964m2) {
    * select b0
    foreach d in 611 491 371 251 131 {
      if `rdate'<`d' {
        local b0 = "b0_`d'"
      }
    }
    noi disp _n as input "$S_DATE $S_TIME " %tm `rdate'
    restore, preserve
    gen ur = 100*(U_`rdate'/(E_`rdate'+U_`rdate'))
    sum mdate if ur!=.
    local lastdate = r(max)
    sum obs if mdate==`lastdate'
    local lastobs = r(mean)
    if `=`lastobs'+`T''>_N {
      local foo = (`lastobs'+`T')-_N
      set obs `=_N+1'
      replace mdate = mdate[_N-1]+`foo' in l
      tsfill
    }
    noi arima ur if mdate>=`lastdate'-179 & mdate<=`lastdate', arima(2,0,1) tech(nr 5 bfgs 30) from(`b0') nolog
    predict urhat, xb
    replace urhat=. if mdate>`=`lastdate'+`T''
    gen ur_`rdate' = urhat/100
    keep mdate ur_`rdate'
    if `i'>1 {
      merge 1:1 mdate using rt-arima-15y.dta, nogen
    }
    save rt-arima-15y.dta, replace
    local i=`++i'
  }
}
*/
use rt-arima-15y.dta
reshape long ur_, i(mdate) j(fcdate)
drop if ur_ ==.
compress
save rt-arima-15y.dta, replace

cap log close

if "$S_OS"=="Unix" exit, STATA clear
